#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define NOP                     126
#define KAZ_DS_SP_SECURITY      128

#define KAZ_DS_SP_N             "69013255533559012681720251530666814963249818281149574315292900710713052\
                                 41215408974961052265819675690960782286932856245381784614188147830907385\
                                 19509475256851584639095976385664268727008220428563902784158579651008511\
                                 65640432323879872602731934033220055455234960542548309849303923865055132\
                                 74564880935"

#define KAZ_DS_SP_G             "57238218309054564034215110463636497158700838676505382250357804712368708\
                                 27657164953921359199088433340921729897741686661987699230332863563098739\
                                 83587853452680844183116773726450798249772871226996817331303367760611882\
                                 30298411313541502294085767011678168093213842251032178060149000370616746\
                                 25163187063"

#define KAZ_DS_SP_ORDERG        "17550380818087469654609546491661742550430100695100874477426921669904285\
                                 595936000"

#define KAZ_DS_SP_LENPHIORDERG     261

#define KAZ_DS_SP_R             "90712696302588818608581806276937354290272881789749948445109699278395925\
                                 64387153469766888399910317215231826121264724035064701686129165847202523\
                                 16759233737219731665495250353856181123922010240787077064390034605931218\
                                 16957332582153453094448737992022723908045947230727867496229086954389872\
                                 4843844753"

#define KAZ_DS_SP_GRg           "4241783443143223177200"

#define KAZ_DS_ALPHABYTES       35
#define KAZ_DS_V1BYTES          11
#define KAZ_DS_V2BYTES          18
#define KAZ_DS_V3BYTES          18
#define KAZ_DS_S1BYTES          35
#define KAZ_DS_S2BYTES          27
#define KAZ_DS_S3BYTES          18

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t ord,
                       mpz_t *pfactors,
                       mpz_t *candidatex,
                       int nof,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
