#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define NOP                     199
#define KAZ_DS_SP_SECURITY      192

#define KAZ_DS_SP_N             "24734878453000044957867110041743882969342068487910107128836431449064728\
                                 06723605462903285316424801913402388307302965058405055284444658476886972\
                                 45487339253572020457758675062720976646421890628409638632703496018774572\
                                 87178774370988417568992391241873243662240717053012638307669964413980797\
                                 12028793409297878707342482008874017014837683777454479591741404751457485\
                                 55394283907998847863962734154014095751600885402986650819314937825122017\
                                 30397666834631238890548716682216034715718663697451995725179818451471402\
                                 7196354101940355"

#define KAZ_DS_SP_G             "24375689181944755465048740997944270180952060385911992129071744088059731\
                                 06163382408439951235727577748153925068953370462571955360910572789779268\
                                 94949716985741963009799460891994723077852960902999173645794122424404518\
                                 51049647494842085870724608180070130250449546912885633843649907594168728\
                                 33551485455171338530926545547199597409810872933546329781630062840529904\
                                 57459704486264729908005633195202690576155489768980144355955662303331685\
                                 47889073836290189846799751041133580233742512844170400263376990006167572\
                                 1230867813835147"

#define KAZ_DS_SP_ORDERG        "53162044609528305645489712845569836435729141547966623590175343118038348\
                                 8093923020230262918063680263514179287418528000"

#define KAZ_DS_SP_LENPHIORDERG  385

#define KAZ_DS_SP_R             "36890965263667572454225394164990181613016712824958247836956025758167154\
                                 23225308392409446262257480261327170924937517840655224833057557329093674\
                                 26969402089286113527773631791449586916180979554438717433454586357870058\
                                 19716120938940372918715925937176631377834736330344205654500828300041977\
                                 47442305525592498263105618039418094300384454050015978948055612618825079\
                                 29310594363323248811780777231755841802983875418928510562315387533857339\
                                 08976310157671564079349210741222959828046182007893168056704510392115947\
                                 137506149957793"

#define KAZ_DS_SP_GRg           "124874859601802485771037442000"

#define KAZ_DS_ALPHABYTES       50
#define KAZ_DS_V1BYTES          13
#define KAZ_DS_V2BYTES          26
#define KAZ_DS_V3BYTES          26
#define KAZ_DS_S1BYTES          50
#define KAZ_DS_S2BYTES          38
#define KAZ_DS_S3BYTES          26

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t ord,
                       mpz_t *pfactors,
                       mpz_t *candidatex,
                       int nof,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
