#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define NOP                     257
#define KAZ_DS_SP_SECURITY      256

#define KAZ_DS_SP_N             "28564313764931634656206830152252990460400211745667697715807393805862958\
                                 36474707132380250109245837797643720249433635550504154133966783276592947\
                                 96417100967003475887690993980439874331883058480006457803145388712278436\
                                 39220694402517139022967985179155489849949896089635955334555440909159119\
                                 70607720924101817343452927425410925645671438067128120542964878885199810\
                                 37033527886366774446415798570712299073358763309566843194867531886933689\
                                 28789547936761113038931201966216248914198475672729324099346789643369722\
                                 18066671104020997969213389797712655010202268303207590192427618429881930\
                                 45142115255045854785185727481340411064899269922319012232572602961190825\
                                 279227088957659957540052601069890446413169020804643403205"

#define KAZ_DS_SP_G             "26686431237970744445184779551402796228569004443082833770838458061594147\
                                 08277178953764635410993644764231461513758299352061145240364185991885481\
                                 36007025460663248139180483256043869710227850502290662993990827349839522\
                                 20796585397018191138113713777644991202548173080705376715931099061614404\
                                 64374718549751850733149585676159853421162236504927515218373794126736521\
                                 83564914649908579930797154237914330652496292204343874498512746275913195\
                                 59580860793679720140596654089529767010426178332848072391548223775791249\
                                 75297959561707418614658918123128666161978428916380722329107009477814488\
                                 12041961039218508773646039361027072366899806177170766495148349311838172\
                                 478364127056259680341370145669119540676471992338934841731"

#define KAZ_DS_SP_ORDERG        "78428373211417300899269678756696499770038323452044098965905188459409544\
                                 45978809904270373967582495486198183122223530783226657557757905683027258\
                                 420766936864000"

#define KAZ_DS_SP_LENPHIORDERG  518

#define KAZ_DS_SP_R             "31224111521747831818533834049172221538197565851510852350820375156471715\
                                 73180694941180192223897931254367200809584137089240554539318782043719796\
                                 66152321192923432945408155958292144714543678572416990315947091828835591\
                                 26912586739195146360093242336811881746059615199940543591225674342669390\
                                 55915436492428563468528314228150641054769328677715341885947511352898124\
                                 51993160257505537900590530800077610917891607889051587323842864297484298\
                                 45272021330772690717887343092815023421156888637080831524834219931446793\
                                 68966128943746302601268731951467645916781198817229243805285566374909671\
                                 10312041622286808915117879433117763660685103969802937514465695548196657\
                                 31026534487445453225466744393908511450546205301194255861"

#define KAZ_DS_SP_GRg           "6761616334344501700575378081332721621024000"

#define KAZ_DS_ALPHABYTES       67
#define KAZ_DS_V1BYTES          20
#define KAZ_DS_V2BYTES          35
#define KAZ_DS_V3BYTES          35
#define KAZ_DS_S1BYTES          67
#define KAZ_DS_S2BYTES          51
#define KAZ_DS_S3BYTES          35

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t ord,
                       mpz_t *pfactors,
                       mpz_t *candidatex,
                       int nof,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
