#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             195
#define KAZ_DS_SP_K             128

#define KAZ_DS_SP_N             "11407459538923317956992856472478034719938444515550504873191432724561240\
                                 77590743470594911066332509539066597551699013776050581430643550167887346\
                                 08191843438244914234171652904624354475977819424112770780591839969259477\
                                 16504087172783276497191148945981028252785414086386424445171843610035797\
                                 71215355642643202854238405781778429260537407631182034795543825674983533\
                                 93399124947777143263677777878879658242357818636034216510614700942625283\
                                 16073897973467968535780096264794534714067794192763112712608847144283240\
                                 4185"

#define KAZ_DS_SP_G             "6007"

#define KAZ_DS_SP_Gg            "17720681536509435215163237615189945478576380515988874530058447706012782\
                                 9364641006743420972687893421171393095806176000"

#define KAZ_DS_SP_nPHIGg        383

#define KAZ_DS_SP_R             "6151"

#define KAZ_DS_SP_GRg           "35678531314800710220296412000"

#define KAZ_DS_SP_Q             "307046942792621152385393422691515827167"

#define KAZ_DS_SP_PHIQ2O2       "47138912539147583318575201508717874817310610524884819045955068373884349\
                                 709361"

#define KAZ_DS_ALPHABYTES       49
#define KAZ_DS_V1BYTES          29
#define KAZ_DS_V2BYTES          33
#define KAZ_DS_S1BYTES          45
#define KAZ_DS_S2BYTES          45

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t product_of_modulus,
                       mpz_t *moduluss,
                       mpz_t *candidate,
                       int no_of_elements,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
