#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             342
#define KAZ_DS_SP_K             256

#define KAZ_DS_SP_N             "30899362774728472813402930925487036907106483346647716077832634208229681\
                                 07962531959560734241391989405902366462221337187560519416251260064227321\
                                 06082661590352303925527901201649129580788573960957561028357743279687597\
                                 49747093923591891123458617559793839630888839380383467100321876543562470\
                                 61213362062661781337190905193292194662760631531056601921913504527118481\
                                 07751097959142127323425808395861273332029465928667158860142396207859547\
                                 78074498210759279292914531779253175131250490084164756441584869258201928\
                                 79176273406824851209859013869638544117670990182233017528174921752629661\
                                 34447192602843362332140861676394949320021847435153149372476489431241044\
                                 28276272016473019197824141603018603454800125471918276469216414911571746\
                                 72668460962414066198498060543077953704972271607635447719007749148942649\
                                 87742361898493588046610193221237596798824666142659564842708753580397824\
                                 21147842091321191449445360355615922323298778630163320925180315247799589\
                                 41928935694291900698197859164061901699987617335054045"

#define KAZ_DS_SP_G             "6007"

#define KAZ_DS_SP_Gg            "96059821280249872265677090702570913737189042824952577209123768240900395\
                                 89464671236957581880496651416879818119211924634227799514556644249432529\
                                 5808384132307951500465714586248917282644088562258250887665096381408000"

#define KAZ_DS_SP_nPHIGg        701

#define KAZ_DS_SP_R             "6151"

#define KAZ_DS_SP_GRg           "5200850540945483985475654433139129917088761950740696000"

#define KAZ_DS_SP_q             "13243757861186655883371248739494892712905616942038016794277221471074626\
                                 9360747"

#define KAZ_DS_SP_Q             "73576432562148088240951381886082737293920094122433426634873452617081260\
                                 75597"

#define KAZ_DS_SP_PHIQ2         "17539712228574334596643458976894075428349469902755340612452759245895881\
                                 84891512734376139462464051042967269751243724018791765824943394440572081\
                                 8989755037262"

#define KAZ_DS_SP_BETA          3

#define KAZ_DS_ALPHABYTES       89
#define KAZ_DS_V1BYTES          56
#define KAZ_DS_V2BYTES          33
#define KAZ_DS_S1BYTES          88
#define KAZ_DS_S2BYTES          88

extern void KAZ_DS_OrderBase(mpz_t Modular,
                             mpz_t FiModular,
                             mpz_t Base,
                             mpz_t OrderBase);
extern int KAZ_DS_GET_PFactors(mpz_t input);
extern void KAZ_DS_PFactors(mpz_t ord,
                            mpz_t *pfacs,
                            int *qlist,
                            int *elist);
extern void KAZ_DS_CRT(mpz_t product_of_modulus,
                       mpz_t *moduluss,
                       mpz_t *candidate,
                       int no_of_elements,
                       mpz_t crt);
extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);
extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);
extern void KAZ_DS_RANDOM(int lb,
                          int ub,
                          mpz_t out);


#endif // FILE_H_INCLUDED
