#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             256
#define KAZ_DS_SP_K             256

#define KAZ_DS_SP_N   			"17556431324481643918996207837893663466748747231510570200250395701206489\
								 46819119319225722255221781068004745082626696712049264987072392917389642\
								 26439521184390581369201594333398816430167829428399789676180324961449561\
								 3965623503535165274921203760243115540869692445583033517796892495953234\
								 15525981617953399959646768741574119584859953169460855595756907122630596\
								 82669546889143624735489600403854474435977797376125804744613861824642513\
								 17073727592917093610260061583664182477824122659663756859210005509733848\
								 93550502219054763243344400110492480332526261112674098966959288164098459\
								 15497364182854692980036000459824241614314644740154825582825605590730843\
								 5942979157318783010165981930589975689252101426431864415"

#define KAZ_DS_SP_G             "6007"
#define KAZ_DS_SP_Gg            "20258251383022919051471872741582121711818017127834269105584366022725712\
								 59108917687449912094947508059165582356293900940316848815657023608162022\
								 47030880288000"
#define KAZ_DS_SP_LGg         	516

#define KAZ_DS_SP_R             "6151"
#define KAZ_DS_SP_GRg           "1690404083586125425143844520333180405256000"
#define KAZ_DS_SP_PHIGRg        "215531152527396013350376745572761600000000"
#define KAZ_DS_SP_PHIPHIGRg     "38880485930520015284446057149235200000000"
#define KAZ_DS_SP_LGRg         	141

#define KAZ_DS_SP_Q             "116431182179248680450031658440253681535"
#define KAZ_DS_SP_PHIQ          "27739969042773783995307880611840000000"

#define KAZ_DS_SP_q             "60728567687543895602471668090967547534666598452738844529628077960649953\
								 095427"

#define KAZ_DS_SP_qQ			"70706989279132580654930521972704671103543461421056657824431812652610572\
								 44815285495186517641999381739652805922840445"
#define KAZ_DS_SP_PHIqQ			"16846085876644599867632367873784903361730038178052598622191124521562525\
								 35871949014954801473509957058785443840000000"

#define KAZ_DS_SKBYTES    		66
#define KAZ_DS_V1BYTES          18
#define KAZ_DS_V2BYTES          48
#define KAZ_DS_SBYTES           66

extern void KAZ_DS_OrderBase(mpz_t Modular, mpz_t FiModular, mpz_t Base, mpz_t OrderBase);

extern int KAZ_DS_GET_PFactors(mpz_t input);

extern void KAZ_DS_PFactors(mpz_t ord, mpz_t *pfacs, mpz_t *qlist, int *elist);

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
						
extern void KAZ_DS_RANDOM(int lb, int ub, mpz_t out);

extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
