#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_DS_SP_J             192
#define KAZ_DS_SP_K             192

#define KAZ_DS_SP_N   			"68209972872768080717484091328330152215633882259208160141348048688433036\
								 47931399626919998579293247227819210569546909150433002363958560379520678\
								 96610120335279513625044688182331298665295698995310030545803859846566158\
								 94479252565383347600043033790026307908717645123725197322146933107123392\
								 90614612953306904815903756168289065100471844399694114217392853491533646\
								 39238571323062885843997257997078494716648543932818807876144984051072225\
								 74485424357672650009586689411950728449951860885387463493304643735"

#define KAZ_DS_SP_G             "6007"
#define KAZ_DS_SP_Gg            "20055775475072077158757356649942783795937368308101083705941179200304201\
								 06665470836984290692168061626938364768000"
#define KAZ_DS_SP_LGg         	370

#define KAZ_DS_SP_R             "6151"
#define KAZ_DS_SP_GRg           "964284630129748924872876000"
#define KAZ_DS_SP_PHIGRg        "137005430034525396664320000"
#define KAZ_DS_SP_PHIPHIGRg     "25983496793805532692480000"
#define KAZ_DS_SP_LGRg         	90

#define KAZ_DS_SP_Q             "116431182179248680450031658440253681535"
#define KAZ_DS_SP_PHIQ          "27739969042773783995307880611840000000"

#define KAZ_DS_SP_q             "5444988124509782366348829596334768200299062998497678312511"

#define KAZ_DS_SP_qQ			"63396640428864406786122242633376791722168653992183433994998499814709468\
								 8709466524471094000184385"
#define KAZ_DS_SP_PHIqQ			"15104380201217224893406117866650938336818493769834710671460906502525501\
								 6477125077526118400000000"

#define KAZ_DS_SKBYTES    		52
#define KAZ_DS_V1BYTES          12
#define KAZ_DS_V2BYTES          40
#define KAZ_DS_SBYTES           52

extern void KAZ_DS_OrderBase(mpz_t Modular, mpz_t FiModular, mpz_t Base, mpz_t OrderBase);

extern int KAZ_DS_GET_PFactors(mpz_t input);

extern void KAZ_DS_PFactors(mpz_t ord, mpz_t *pfacs, mpz_t *qlist, int *elist);

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern char* KAZ_DS_MLOG(mpz_t Modular,
                        mpz_t OrderBase,
                        mpz_t Base,
                        mpz_t Target,
                        mpz_t *pfactors,
                        int *qlist,
                        int *elist,
                        int saiz,
                        mpz_t kaz_crt);
						
extern void KAZ_DS_RANDOM(int lb, int ub, mpz_t out);

extern void KAZ_DS_KeyGen(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
